#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)


const int N = 5e5 + 3;
const int logn = 20;
vector<int> adj[N];
int b[N], x[N];
int up[N][logn];
int tin[N], tout[N], timer = 0;


struct segtree {
    int size_s = 1;
    const long long NO_OPERATION = LLONG_MAX;
    vector<long long> nexts, prevs;
    void init(int n) {
        while(size_s <= n)
            size_s *= 2;
        nexts.assign(4 * size_s, NO_OPERATION);
        prevs.assign(4 * size_s, NO_OPERATION);
    }
    void propagate(int lx, int rx, int x) {
        if (rx - lx == 1) return;
        if (nexts[x] != NO_OPERATION) {
            nexts[x * 2 + 1] = nexts[x];
            nexts[x * 2 + 2] = nexts[x];
        }
        nexts[x] = NO_OPERATION;
        if (prevs[x] != NO_OPERATION) {
            prevs[x * 2 + 1] = prevs[x];
            prevs[x * 2 + 2] = prevs[x];
        }
        prevs[x] = NO_OPERATION;
    }
    void modify(int l, int r, int lx, int rx, int x, long long v, int type) {
        propagate(lx, rx, x);
        if (lx >= r || rx <= l) return;
        if (lx >= l && rx <= r) {
            if (type == 0)
                nexts[x] = v;
            else
                prevs[x] = v;
            return;
        }
        int m = (lx + rx) / 2;
        modify(l, r, lx, m, x * 2 + 1, v, type);
        modify(l, r, m, rx, x * 2 + 2, v, type);
    }
    long long get(int i, int lx, int rx, int x, int type) {
        propagate(lx, rx, x);
        if (rx - lx == 1)
            return (type == 0 ? nexts[x] : prevs[x]);

        int m = (lx + rx) / 2;
        long long res;
        if (i < m)
            res = get(i, lx, m, x * 2 + 1, type);
        else
            res = get(i, m, rx, x * 2 + 2, type);

        if (res == NO_OPERATION)
            return 0;
        return res;
    }
}; segtree st;

int GoUp(int u, int p) {
    for (int i = logn - 1; i >= 0; i--) {
        if (p >= (1 << i)) {
            u = up[u][i];
            p -= (1 << i);
        }
    }
    return u;
}

void dfs(int u, int prev) {
    tin[u] = timer++;
    up[u][0] = prev;
    for (int i = 1; i < logn; i++)
        up[u][i] = up[up[u][i-1]][i-1];

    for (auto v : adj[u]) {
        dfs(v, u);
    }
    tout[u] = ++timer;
}

void solve() {
    int n; cin >> n;
    st.init(n);
    int z = n+1;
    for (int i = 0; i < n - 1; i++) {
        int u, v; cin >> u >> v;
        adj[u].push_back(v);
        if (i == n - 2)
            adj[v].push_back(z);
    }
    adj[0].push_back(1);

    for (int i = 1; i <= n; i++) cin >> b[i];
    for (int i = 1; i <= n; i++) cin >> x[i];
    st.modify(0, n+2, 0, n+2, 0, z, 1);

    dfs(0, 0);

    for (int i = 1; i <= n; i++) {
        if (b[i] == 1) {
            int next_node = st.get(tin[i], 0, n+2, 0, 0);
            int prev_node = st.get(tin[i], 0, n+2, 0, 1);
            int l = tin[next_node] + 1, r = tin[prev_node];
            if (l <= tin[i])
                st.modify(l, tin[i]+1, 0, n+2, 0, i, 1);
            st.modify(tin[i], r, 0, n+2, 0, i, 0);
        }
    }

    for (int i = 1; i <= n; i++) {
        if (x[i] != 0) {
            if (b[x[i]] == 0) {
                int next_node = st.get(tin[x[i]], 0, n+2, 0, 0);
                int prev_node = st.get(tin[x[i]], 0, n+2, 0, 1);
                int l = tin[next_node] + 1, r = tin[prev_node];
                if (l <= tin[x[i]])
                    st.modify(l, tin[x[i]]+1, 0, n+2, 0, x[i], 1);
                st.modify(tin[x[i]], r, 0, n+2, 0, x[i], 0);
            } else {
                int next_node = st.get(tin[x[i]]-1, 0, n+2, 0, 0);
                int prev_node = st.get(tin[x[i]]+1, 0, n+2, 0, 1);
                int l = tin[next_node] + 1, r = tin[prev_node];
                if (l <= tin[x[i]])
                    st.modify(l, tin[x[i]]+1, 0, n+2, 0, prev_node, 1);
                st.modify(tin[x[i]], r, 0, n+2, 0, next_node, 0);
            }

            b[x[i]] ^= 1;
        }

        int ans = 0, curr = i;
        while (curr != 0) {
            ans++;
            int node = GoUp(curr, i);
            if (i == 1)
                dbg(curr, node, i);
            if (node == 0) break;
            int prev_node = st.get(tin[node], 0, n+2, 0, 1);
            if (i == 1)
                dbg(prev_node, node);
            if (tin[prev_node] >= tin[curr]) {ans = -1; break;}
            curr = prev_node;
        }

        cout << ans << " ";
    }
}

int main() {
    ios::sync_with_stdio(false); cin.tie(0);
    solve();
}
/*
4
4 3
3 2
2 1
0 0 0 0
0 0 0 0
*/